/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.sdgraph;

import cz.insophy.inplan.sdgraph.AbstractSdgNode;
import cz.insophy.inplan.sdgraph.SdgNodeVisitor;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.store.ExternalStoreActivity;
import javax.annotation.Nonnull;

public class SdgEsaNode
extends AbstractSdgNode {
    private final ExternalStoreActivity esa;

    SdgEsaNode(ExternalStoreActivity esa) {
        this.esa = esa;
    }

    public ExternalStoreActivity getEsa() {
        return this.esa;
    }

    @Override
    public double getTotalIncomingQty(@Nonnull Material material) {
        if (this.esa.getQty() > 0.0 || material != this.esa.getMaterial()) {
            return 0.0;
        }
        return Math.abs(this.esa.getQty());
    }

    @Override
    public double getTotalOutgoingQty(@Nonnull Material material) {
        if (this.esa.getQty() < 0.0 || material != this.esa.getMaterial()) {
            return 0.0;
        }
        return Math.abs(this.esa.getQty());
    }

    public String toString() {
        return "SdgEsaNode{esa=" + this.esa + "}";
    }

    @Override
    public <T> T accept(SdgNodeVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

